define([
    'underscore',
    'modules/new-appointment-request/resources/common/facility/model',
    'modules/new-appointment-request/tests/helpers/facility-helper',
], function(_, Model, helpers) {
    'use strict';

    describe('Scheduling Facility Model', function() {

        var data;
        var options;

        beforeEach(function() {
            data = helpers.mockPatientFacility();
            options = {parse: true};
        });

        it('initialize correctly', function() {
            var model = new Model(data[0], options);

            expect(model.id).toBe(data[0].institution.institutionCode);
            expect(model.isRequestSupported()).toBeTruthy();
            expect(model.isDirectSchedulingSupported()).toBeTruthy();
        });

        it('parse correctly', function() {
            var item = data[0];
            var institution = item.institution;
            var model = new Model(item, options);

            expect(model.get('institutionCode')).toEqual(institution.institutionCode);
            expect(model.get('name')).toEqual(institution.name);
            expect(model.get('city')).toEqual(institution.city);
            expect(model.get('stateAbbrev')).toEqual(institution.stateAbbrev);
        });

        it('handles isRequestSupported', function() {
            var trueModel = new Model(data[0], options);
            var falseModel = new Model(data[1], options);

            expect(trueModel.isRequestSupported()).toBeTruthy();
            expect(falseModel.isRequestSupported()).toBeFalsy();
        });

        it('handles directSchedulingSupported', function() {
            var trueModel = new Model(data[0], options);
            var falseModel = new Model(data[1], options);

            expect(trueModel.isDirectSchedulingSupported()).toBeTruthy();
            expect(falseModel.isDirectSchedulingSupported()).toBeFalsy();
        });

        it('creates the correct select text values', function() {
            var EXPECT_NAME = 'The name';
            var EXPECT_NAME_CITY_STATE = 'PITTSFIELD CBOC (PITTSFIELD, MA)';

            var nameModel = new Model({name: EXPECT_NAME}, options);
            var fullModel = new Model(data[0], options);

            expect(nameModel.formatTextValue(false)).toBe(EXPECT_NAME);
            expect(fullModel.formatTextValue(false)).toBe(EXPECT_NAME_CITY_STATE);
        });

        it('creates the correct select object', function() {
            var model = new Model(data[0], options);
            var id = data[0].institution.institutionCode;
            var text = 'PITTSFIELD CBOC (PITTSFIELD, MA)';

            expect(model.toSectionData()).toEqual({
                id: id,
                value: id,
                text: text,
                hasPactLabel: false,
            });
        });

        it('creates a select object with a pact label if facility matches institution code in the list', function() {
            var model = new Model(data[0], options);
            var id = data[0].institution.institutionCode;
            var text = 'PITTSFIELD CBOC (PITTSFIELD, MA) - Your Primary Care Team';

            expect(model.toSectionData([id])).toEqual({
                id: id,
                value: id,
                text: text,
                hasPactLabel: true,
            });
        });
    });
});
